<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ScoringRule;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class ScoringRulesController extends Controller
{
     /**
     * Display a listing of the scoring rules.
     */
    public function index()
    {
        $scoringRules = ScoringRule::paginate(10);
        return view('admin.scoring_rules.index', compact('scoringRules'));
    }

     /**
     * Show the form for creating a new scoring rule.
     */
    public function create()
    {
        return view('admin.scoring_rules.create');
    }

    /**
     * Store a newly created scoring rule in storage.
     */
    public function store(Request $request)
    {
        // Validação dos dados do formulário
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'amount_spent_per_point' => 'required|numeric|min:0',
            'is_active' => 'required|boolean',
            'is_featured' => 'required|boolean',
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        // Criação da nova regra de pontuação
        ScoringRule::create([
            'name' => $request->input('name'),
            'amount_spent_per_point' => $request->input('amount_spent_per_point'),
            'is_active' => $request->input('is_active'),
            'is_featured' => $request->input('is_featured'),
            'admin_id' => Auth::id(), // Atribui o ID do admin logado
        ]);

        return redirect()->route('admin.scoring-rules.index')
            ->with('message', 'Regra de pontuação criada com sucesso.');
    }

    /**
     * Show the form for editing the specified scoring rule.
     */
    public function edit($id)
    {
        $scoringRule = ScoringRule::findOrFail($id);
        return view('admin.scoring_rules.edit', compact('scoringRule'));
    }

    /**
     * Update the specified scoring rule in storage.
     */
    public function update(Request $request, $id)
    {
        $scoringRule = ScoringRule::findOrFail($id);

        // Validação dos dados do formulário
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'amount_spent_per_point' => 'required|numeric|min:0',
            'is_active' => 'required|boolean',
            'is_featured' => 'required|boolean',
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        // Atualização da regra de pontuação
        $scoringRule->update([
            'name' => $request->input('name'),
            'amount_spent_per_point' => $request->input('amount_spent_per_point'),
            'is_active' => $request->input('is_active'),
            'is_featured' => $request->input('is_featured'),
        ]);

        return redirect()->route('admin.scoring-rules.index')
            ->with('message', 'Regra de pontuação atualizada com sucesso.');
    }

    /**
     * Remove the specified scoring rule from storage.
     */
    public function destroy($id)
    {
        $scoringRule = ScoringRule::findOrFail($id);
        $scoringRule->delete();

        return redirect()->route('admin.scoring-rules.index')
            ->with('message', 'Regra de pontuação excluída com sucesso.');
    }
}
