<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use App\Models\Image;
use Illuminate\Support\Facades\Log;

class ImageUploadController extends Controller
{
    public function upload(Request $request)
    {
        Log::info('Iniciando upload de imagem...');

        if ($request->hasFile('files')) {
            Log::info('Arquivo encontrado na requisição.');

            $file = $request->file('files')[0]; // Pega o primeiro arquivo
            Log::info('Nome do arquivo: ' . $file->getClientOriginalName());
            Log::info('Tamanho do arquivo: ' . $file->getSize());
            Log::info('Tipo de arquivo: ' . $file->getMimeType());

            $path = $file->store('images', 'public');
            Log::info('Arquivo armazenado no caminho: ' . $path);

            if ($path) {
                $image = Image::create([
                    'filename' => basename($path),
                    'path' => $path,
                ]);

                Log::info('Imagem salva no banco de dados com ID: ' . $image->id);

                return response()->json(['success' => true, 'image_id' => $image->id, 'location' => Storage::url($path)]);
            } else {
                Log::error('Erro ao armazenar o arquivo.');
                return response()->json(['error' => 'Erro ao armazenar o arquivo.'], 500);
            }
        }

        Log::error('Nenhum arquivo encontrado na requisição.');
        return response()->json(['error' => 'Nenhum arquivo encontrado.'], 400);
    }

    public function index(Request $request)
    {
        $images = Image::paginate(10);
        return view('admin.images.index', compact('images'));
    }

    public function destroy(Image $image)
    {
        Log::info('Iniciando exclusão de imagem com ID: ' . $image->id);
        
        Storage::disk('public')->delete($image->path);
        $image->delete();

        Log::info('Imagem excluída com sucesso.');
        return response()->json(['success' => true]);
    }
}
