<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Point; // Certifique-se de que o modelo está importado
use App\Models\Ranking; // Importa o modelo de Ranking
use App\Models\User; // Importa o modelo de User
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    /**
     * Show the admin dashboard.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        Carbon::setLocale('pt_BR'); // Define o local para português do Brasil
        // Obter o mês atual
        $currentMonth = Carbon::now()->month;

        // Obter o total em vendas no mês
        $totalSales = Point::whereMonth('created_at', $currentMonth)->sum('sale_value');

        // Obter o número de vendas no mês
        $numberOfSales = Point::whereMonth('created_at', $currentMonth)->count();

        // Obter o total de pontos distribuídos no mês
        $totalPointsDistributed = Point::whereMonth('created_at', $currentMonth)->sum('points');

        // Obter rankings ativos
        $activeRankings = Ranking::where('is_active', true)->get();

        // Obter os aniversariantes do mês
        // Obter os aniversariantes do mês
        $birthdayArchitects = User::where('role', 'architect')
            ->join('architect_profiles', 'users.id', '=', 'architect_profiles.user_id')
            ->whereMonth('architect_profiles.birth_date', $currentMonth)
            ->select('users.id', 'users.name', 'architect_profiles.birth_date')
            ->orderBy('architect_profiles.birth_date', 'asc')
            ->get();

        // Obter os últimos 9 meses de dados de vendas
        $salesData = Point::select(
                DB::raw('SUM(sale_value) as total_sales'),
                DB::raw('COUNT(id) as total_sales_count'),
                DB::raw('MONTH(created_at) as month')
            )
            ->where('created_at', '>=', Carbon::now()->subMonths(3))
            ->groupBy('month')
            ->orderBy('month')
            ->get();

        // Preencher os dados para o gráfico
        $salesByMonth = [];
        $salesCountByMonth = [];
        $months = [];

        for ($i = 2; $i >= 0; $i--) {
            $date = Carbon::now()->subMonths($i);
            $month = $date->format('M');
            $months[] = $month;

            $salesForMonth = $salesData->firstWhere('month', $date->month);
            if ($salesForMonth) {
                $salesByMonth[] = $salesForMonth->total_sales;
                $salesCountByMonth[] = $salesForMonth->total_sales_count;
            } else {
                $salesByMonth[] = 0;
                $salesCountByMonth[] = 0;
            }
        }

        // Obter o total de vendas e pontos distribuídos no mês atual
        $totalSalesThisMonth = Point::whereMonth('created_at', $currentMonth)->sum('sale_value');
        $numberOfSalesThisMonth = Point::whereMonth('created_at', $currentMonth)->count();

        // Obter o total de vendas e pontos distribuídos no ano atual
        $currentYear = Carbon::now()->year;
        $totalSalesThisYear = Point::whereYear('created_at', $currentYear)->sum('sale_value');
        $numberOfSalesThisYear = Point::whereYear('created_at', $currentYear)->count();

        // Passar os dados para a view
        return view('admin.dashboard', compact(
            'totalSales',
            'numberOfSales',
            'totalPointsDistributed',
            'activeRankings',
            'birthdayArchitects',
            'salesByMonth',
            'salesCountByMonth',
            'months',
            'totalSalesThisMonth',
            'numberOfSalesThisMonth',
            'totalSalesThisYear',
            'numberOfSalesThisYear'
        ));
    }
}
